/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2ba.APSet;
import jltl2ba.SimpleLTL;
import jltl2dstar.DRA;
import jltl2dstar.DRAOptimizations;
import jltl2dstar.NBA;
import jltl2dstar.NBA2DRA;
import jltl2dstar.Options_LTL2DRA;
import jltl2dstar.Options_Safra;
import prism.PrismException;

public class LTL2DRA {
    private Options_Safra _safra_opt;

    public LTL2DRA(Options_Safra options_Safra) {
        this._safra_opt = options_Safra;
    }

    private DRA LTLtoDRA_rec(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA) throws PrismException {
        SimpleLTL simpleLTL2 = simpleLTL.clone().simplify();
        if (options_LTL2DRA.allow_union && simpleLTL2.kind == SimpleLTL.LTLType.OR) {
            SimpleLTL simpleLTL3 = simpleLTL2.left;
            SimpleLTL simpleLTL4 = simpleLTL2.right;
            Options_LTL2DRA options_LTL2DRA2 = options_LTL2DRA.clone();
            options_LTL2DRA2.recursion();
            DRA dRA = this.LTLtoDRA_rec(simpleLTL3, aPSet, options_LTL2DRA2);
            DRA dRA2 = this.LTLtoDRA_rec(simpleLTL4, aPSet, options_LTL2DRA2);
            return dRA.calculateUnion(dRA2, options_LTL2DRA.opt_safra.union_trueloop, options_LTL2DRA.detailed_states);
        }
        NBA nBA = simpleLTL2.toNBA(aPSet);
        if (nBA == null) {
            throw new PrismException("Couldn't create NBA from LTL formula");
        }
        NBA2DRA nBA2DRA = new NBA2DRA(options_LTL2DRA.opt_safra, false);
        DRA dRA = nBA2DRA.convert(nBA, 0);
        if (options_LTL2DRA.optimizeAcceptance) {
            dRA.optimizeAcceptanceCondition();
        }
        if (options_LTL2DRA.bisim) {
            DRAOptimizations dRAOptimizations = new DRAOptimizations();
            dRA = dRAOptimizations.optimizeBisimulation(dRA, false, false, false);
        }
        return dRA;
    }

    public DRA LTLtoDRA(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA) throws PrismException {
        return this.LTLtoDRA_rec(simpleLTL, aPSet, options_LTL2DRA);
    }

    DRA nba2dra(NBA nBA, int n, boolean bl) throws PrismException {
        DRA dRA = null;
        NBA2DRA nBA2DRA = new NBA2DRA(this._safra_opt, bl);
        try {
            dRA = nBA2DRA.convert(nBA, n);
        }
        catch (PrismException prismException) {
            dRA = null;
            throw prismException;
        }
        return dRA;
    }

    public Options_Safra getOptions() {
        return this._safra_opt;
    }
}

