/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBIndex;
import java.util.Objects;

public class UMBType {
    public Type type;
    public Integer size;

    public static UMBType create(Type type) {
        UMBType uMBType = new UMBType();
        uMBType.type = type;
        uMBType.size = type.defaultSize();
        return uMBType;
    }

    public static UMBType create(Type type, Integer n) {
        UMBType uMBType = new UMBType();
        uMBType.type = type;
        uMBType.size = n;
        return uMBType;
    }

    public static UMBType contNum(boolean bl) {
        return UMBType.contNum(bl, false);
    }

    public static UMBType contNum(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return UMBType.create(Type.RATIONAL_INTERVAL);
            }
            return UMBType.create(Type.RATIONAL);
        }
        if (bl2) {
            return UMBType.create(Type.DOUBLE_INTERVAL);
        }
        return UMBType.create(Type.DOUBLE);
    }

    public boolean isDefaultSize() {
        return this.size == null || Objects.equals(this.size, this.type.defaultSize());
    }

    public static enum Type implements UMBIndex.UMBField
    {
        BOOL,
        INT,
        UINT,
        INT_INTERVAL,
        UINT_INTERVAL,
        DOUBLE,
        DOUBLE_INTERVAL,
        RATIONAL,
        RATIONAL_INTERVAL,
        STRING;


        public String toString() {
            return this.description();
        }

        public boolean isContinuousNumeric() {
            switch (this.ordinal()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        public boolean isDouble() {
            switch (this.ordinal()) {
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        public boolean isRational() {
            switch (this.ordinal()) {
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        public boolean isInterval() {
            switch (this.ordinal()) {
                case 6: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        public Integer defaultSize() {
            switch (this.ordinal()) {
                case 0: {
                    return 1;
                }
                case 1: 
                case 2: 
                case 5: {
                    return 64;
                }
                case 3: 
                case 4: 
                case 6: {
                    return 128;
                }
                case 7: {
                    return 128;
                }
                case 8: {
                    return 256;
                }
                case 9: {
                    return 64;
                }
            }
            return null;
        }
    }
}

