/*
 * Decompiled with CFR 0.152.
 */
package io;

import explicit.Model;
import explicit.PartiallyObservableModel;
import io.ModelAccess;
import io.ModelExportOptions;
import io.ModelExporter;
import io.github.pmctools.umbj.UMBBitPacking;
import io.github.pmctools.umbj.UMBBitString;
import io.github.pmctools.umbj.UMBException;
import io.github.pmctools.umbj.UMBFormat;
import io.github.pmctools.umbj.UMBIndex;
import io.github.pmctools.umbj.UMBType;
import io.github.pmctools.umbj.UMBWriter;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import parser.EvaluateContext;
import parser.State;
import parser.VarList;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationDoubleUnbounded;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.type.Type;
import prism.Evaluator;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class UMBExporter<Value>
extends ModelExporter<Value> {
    public UMBExporter() {
    }

    public UMBExporter(ModelExportOptions modelExportOptions) {
        super(modelExportOptions);
    }

    @Override
    public void exportModel(Model<Value> model, PrismLog prismLog) throws PrismException {
        if (!this.modelExportOptions.getBinaryAsText()) {
            throw new PrismException("Export in UMB binary format must be to a file");
        }
        UMBWriter uMBWriter = this.createUMBWriter(model);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            uMBWriter.exportAsText(stringBuffer);
            prismLog.print(stringBuffer.toString());
        }
        catch (UMBException uMBException) {
            throw new PrismException(uMBException.getMessage());
        }
    }

    @Override
    public void exportModel(Model<Value> model, File file) throws PrismException {
        Object object;
        if (this.modelExportOptions.getBinaryAsText()) {
            object = new PrismFileLog(file.getPath());
            try {
                this.exportModel(model, (PrismLog)object);
            }
            finally {
                ((PrismFileLog)object).close();
            }
        }
        object = this.createUMBWriter(model);
        try {
            ModelExportOptions.CompressionFormat compressionFormat = ModelExportOptions.CompressionFormat.fromUMB(UMBFormat.DEFAULT_COMPRESSION_FORMAT);
            UMBFormat.CompressionFormat compressionFormat2 = this.modelExportOptions.getCompressionFormat(compressionFormat).toUMB();
            ((UMBWriter)object).export(file, this.modelExportOptions.getZipped(), compressionFormat2);
        }
        catch (UMBException uMBException) {
            throw new PrismException(uMBException.getMessage());
        }
    }

    private UMBWriter createUMBWriter(Model<Value> model) throws PrismException {
        this.setEvaluator(model.getEvaluator());
        Evaluator evaluator = this.getRewardEvaluator();
        ModelType modelType = model.getModelType();
        int n = model.getNumStates();
        boolean bl = this.modelExportOptions.getShowActions();
        List<Object> list = model.getActions();
        if (list.isEmpty() || list.size() == 1 && list.get(0) == null) {
            bl = false;
        }
        if (modelType.uncertain() && !modelType.intervals()) {
            throw new PrismNotSupportedException(String.valueOf((Object)modelType) + "s cannot yet be exported to UMB");
        }
        if (model.getEvaluator().isSymbolic()) {
            throw new PrismNotSupportedException("Parametric models cannot yet be exported to UMB");
        }
        ModelAccess<Value> modelAccess = ModelAccess.wrap(model);
        try {
            Object object;
            int n2;
            int n3;
            int n4;
            boolean bl2;
            UMBWriter uMBWriter = new UMBWriter();
            this.buildIndex(modelAccess, uMBWriter.getUmbIndex());
            if (modelType.nondeterministic()) {
                uMBWriter.addStateChoiceOffsets(modelAccess.getStateChoiceOffsets());
                if (modelType.isProbabilistic()) {
                    uMBWriter.addChoiceBranchOffsets(modelAccess.getChoiceTransitionOffsets());
                }
            } else {
                uMBWriter.addChoiceBranchOffsets(modelAccess.getStateTransitionOffsets());
            }
            if (model.getModelType().isProbabilistic()) {
                uMBWriter.addBranchProbabilities(modelAccess.getTransitionProbabilitiesAsPrimitives());
                if (model.getModelType() == ModelType.CTMC) {
                    uMBWriter.addExitRates(modelAccess.getExitRatesAsPrimitives());
                }
            }
            uMBWriter.addBranchTargets(modelAccess.getTransitionSuccessors());
            uMBWriter.addInitialStates(modelAccess.getInitialStates());
            if (bl) {
                if (modelType.nondeterministic()) {
                    if (model.getActions().size() > 1) {
                        uMBWriter.addChoiceActions(modelAccess.getChoiceActionIndices(), modelAccess.getActionStrings());
                    } else {
                        uMBWriter.addSingleChoiceAction(modelAccess.getActionStrings().get(0));
                    }
                } else if (model.getActions().size() > 1) {
                    uMBWriter.addBranchActions(modelAccess.getTransitionActionIndices(), modelAccess.getActionStrings());
                } else {
                    uMBWriter.addSingleBranchAction(modelAccess.getActionStrings().get(0));
                }
            }
            if (modelType.partiallyObservable()) {
                uMBWriter.addStateObservations(modelAccess.getStateObservations());
            }
            if (bl2 = this.modelExportOptions.getShowLabels()) {
                n4 = this.getNumLabels();
                for (n3 = 0; n3 < n4; ++n3) {
                    uMBWriter.addStateAP(this.getLabelName(n3), this.getLabel(n3));
                }
            }
            if ((n4 = (int)(this.modelExportOptions.getShowRewards() ? 1 : 0)) != 0) {
                n3 = this.getNumRewards();
                for (n2 = 0; n2 < n3; ++n2) {
                    object = this.getReward(n2);
                    String string = uMBWriter.addRewards(this.getRewardName(n2), evaluator.exact());
                    if (object.hasStateRewards()) {
                        uMBWriter.addStateRewardsByID(string, modelAccess.getStateRewardsAsPrimitives(this.getReward(n2)));
                    }
                    if (object.hasTransitionRewards()) {
                        if (modelType.nondeterministic()) {
                            uMBWriter.addChoiceRewardsByID(string, modelAccess.getTransitionRewardsAsPrimitives(this.getReward(n2)));
                        } else {
                            uMBWriter.addBranchRewardsByID(string, modelAccess.getTransitionRewardsAsPrimitives(this.getReward(n2)));
                        }
                    }
                    if (object.hasStateRewards() || object.hasTransitionRewards()) continue;
                    uMBWriter.addStateRewardsByID(string, Collections.nCopies(n, 0.0).iterator());
                }
            }
            if ((n3 = (int)(this.modelExportOptions.getShowStates() ? 1 : 0)) != 0 && this.modelInfo != null && model.getStatesList() != null) {
                VarList varList = this.modelInfo.createVarList();
                this.storeVarInfo(varList, model.getStatesList(), UMBIndex.UMBEntity.STATES, uMBWriter);
            }
            if ((n2 = (int)(this.modelExportOptions.getShowObservations() ? 1 : 0)) != 0 && this.modelInfo != null && this.modelInfo.getModelType().partiallyObservable()) {
                object = new VarList();
                ((VarList)object).setEvaluateContext(this.modelInfo.getEvaluateContext());
                int n5 = this.modelInfo.getNumObservables();
                for (int i = 0; i < n5; ++i) {
                    String string = this.modelInfo.getObservableName(i);
                    Type type = this.modelInfo.getObservableType(i);
                    DeclarationType declarationType = type.defaultDeclarationType();
                    ((VarList)object).addVar(string, declarationType, -1);
                }
                this.storeVarInfo((VarList)object, ((PartiallyObservableModel)model).getObservationsList(), UMBIndex.UMBEntity.OBSERVATIONS, uMBWriter);
            }
            return uMBWriter;
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    private void buildIndex(ModelAccess<Value> modelAccess, UMBIndex uMBIndex) {
        uMBIndex.fileData.tool = Prism.getToolName();
        uMBIndex.fileData.toolVersion = Prism.getVersion();
        this.storeModelTypeInIndex(modelAccess, uMBIndex);
        this.storeModelStatsInIndex(modelAccess, uMBIndex);
    }

    private void storeModelTypeInIndex(ModelAccess<Value> modelAccess, UMBIndex uMBIndex) {
        ModelType modelType = modelAccess.getModelType();
        uMBIndex.setTime(modelType.continuousTime() ? UMBIndex.Time.STOCHASTIC : UMBIndex.Time.DISCRETE);
        uMBIndex.setNumPlayers(modelAccess.getNumPlayers());
        uMBIndex.setNumObservations(modelAccess.getNumObservations());
        if (modelAccess.getNumObservations() > 0) {
            uMBIndex.setObservationsApplyTo(UMBIndex.UMBEntity.STATES);
        }
        boolean bl = modelAccess.getEvaluator().exact();
        if (modelType.isProbabilistic()) {
            uMBIndex.setBranchProbabilityType(UMBType.contNum(bl, modelType.intervals()));
            if (!modelType.choicesSumToOne()) {
                uMBIndex.setExitRateType(UMBType.contNum(bl, modelType.intervals()));
            }
        }
    }

    private void storeModelStatsInIndex(ModelAccess<Value> modelAccess, UMBIndex uMBIndex) {
        uMBIndex.setNumStates(modelAccess.getNumStates());
        uMBIndex.setNumInitialStates(modelAccess.getNumInitialStates());
        uMBIndex.setNumChoices(modelAccess.getNumChoices());
        uMBIndex.setNumBranches(modelAccess.getNumTransitions());
        if (this.modelExportOptions.getShowActions()) {
            List<Object> list = modelAccess.getActions();
            int n = list.size();
            if (n == 1 && list.get(0) == null) {
                n = 0;
            }
            if (modelAccess.getModelType().nondeterministic()) {
                uMBIndex.setNumChoiceActions(n);
                uMBIndex.setNumBranchActions(0);
            } else {
                uMBIndex.setNumChoiceActions(0);
                uMBIndex.setNumBranchActions(n);
            }
        } else {
            uMBIndex.setNumChoiceActions(0);
            uMBIndex.setNumBranchActions(0);
        }
    }

    private void storeVarInfo(VarList varList, List<State> list, UMBIndex.UMBEntity uMBEntity, UMBWriter uMBWriter) throws PrismException {
        try {
            int n = varList.getNumVars();
            boolean bl = false;
            UMBBitPacking uMBBitPacking = new UMBBitPacking();
            for (int i = 0; i < n; ++i) {
                UMBType uMBType;
                DeclarationType declarationType = varList.getDeclarationType(i);
                if (declarationType instanceof DeclarationBool) {
                    uMBType = UMBType.create(UMBType.Type.BOOL, 1);
                } else if (declarationType instanceof DeclarationInt) {
                    if (bl) {
                        uMBType = UMBType.create(UMBType.Type.INT, varList.getRangeLogTwo(i));
                    } else {
                        int n2 = varList.getLow(i);
                        int n3 = varList.getHigh(i);
                        if (n2 < 0) {
                            int n4 = Math.abs(n2);
                            if (n3 > 0) {
                                n4 = Math.max(n4, n3 + 1);
                            }
                            uMBType = UMBType.create(UMBType.Type.INT, (int)Math.ceil(PrismUtils.log2(n4)) + 1);
                        } else {
                            uMBType = UMBType.create(UMBType.Type.UINT, (int)Math.ceil(PrismUtils.log2(n3 + 1)));
                        }
                    }
                } else if (declarationType instanceof DeclarationIntUnbounded) {
                    uMBType = UMBType.create(UMBType.Type.INT, 32);
                } else if (declarationType instanceof DeclarationDoubleUnbounded) {
                    uMBType = UMBType.create(UMBType.Type.DOUBLE, 64);
                } else {
                    throw new PrismException("Unsupported variable type in UMB export: " + String.valueOf(declarationType));
                }
                uMBBitPacking.addVariable(varList.getName(i), uMBType);
            }
            uMBBitPacking.padToByteBoundary();
            uMBWriter.addValuationDescription(uMBEntity, true, uMBBitPacking);
            Iterator<UMBBitString> iterator = list.stream().map(state -> {
                UMBBitString uMBBitString = uMBBitPacking.newBitString();
                Object object = null;
                try {
                    block9: for (int i = 0; i < n; ++i) {
                        UMBType.Type type = uMBBitPacking.getVariable((int)i).getType().type;
                        object = state.varValues[i];
                        object = varList.getType(i).castValueTo(object, EvaluateContext.EvalMode.FP);
                        switch (type) {
                            case BOOL: {
                                uMBBitPacking.setBooleanVariableValue(uMBBitString, i, (Boolean)object);
                                continue block9;
                            }
                            case INT: {
                                uMBBitPacking.setIntVariableValue(uMBBitString, i, (Integer)object);
                                continue block9;
                            }
                            case UINT: {
                                uMBBitPacking.setUIntVariableValue(uMBBitString, i, (Integer)object);
                                continue block9;
                            }
                            case DOUBLE: {
                                uMBBitPacking.setDoubleVariableValue(uMBBitString, i, (Double)object);
                                continue block9;
                            }
                            default: {
                                throw new PrismException("Unsupported variable type in UMB export: " + String.valueOf(type));
                            }
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new RuntimeException("Was not expecting data as " + object.getClass().getSimpleName());
                }
                catch (UMBException | PrismException exception) {
                    throw new RuntimeException(exception);
                }
                return uMBBitString;
            }).iterator();
            uMBWriter.addValuations(uMBEntity, iterator, uMBBitPacking);
        }
        catch (UMBException | RuntimeException exception) {
            throw new PrismException("UMB export problem: " + exception.getMessage());
        }
    }
}

