/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMDP;
import explicit.CTMDPModelChecker;
import explicit.Distribution;
import explicit.DistributionSet;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.NondetModelSimple;
import explicit.ProbModelChecker;
import explicit.STPG;
import explicit.STPGAbstrSimple;
import explicit.STPGModelChecker;
import explicit.Utils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public abstract class QuantAbstractRefine
extends PrismComponent {
    protected ProbModelChecker mc;
    protected ProbModelChecker mcOptions;
    protected int verbosity = 0;
    protected int maxRefinements = 1000;
    protected boolean exportDot = false;
    protected boolean optimise = true;
    protected RefineTermCrit refineTermCrit = RefineTermCrit.ABSOLUTE;
    protected double refineTermCritParam = 1.0E-6;
    protected boolean above = false;
    protected RefineStratWhere refineStratWhere = RefineStratWhere.ALL;
    protected RefineStratHow refineStratHow = RefineStratHow.VAL;
    protected boolean sanityChecks = false;
    protected ModelType modelType = ModelType.MDP;
    protected PropertyType propertyType = PropertyType.PROB_REACH;
    protected boolean min;
    protected int reachBound = 0;
    protected NondetModelSimple<Double> abstraction;
    protected BitSet target;
    protected ModelType abstractionType;
    protected double[] lbSoln;
    protected double[] ubSoln;
    protected double[] lbLastSoln;
    protected double[] ubLastSoln;
    protected double lbInit;
    protected double ubInit;
    protected BitSet known;
    protected List<Integer> refineStates;
    protected boolean buildEmbeddedDtmc = false;
    protected double timeBuild;
    protected double timeRebuild;
    protected double timeCheck;
    protected double timeCheckLb;
    protected double timeCheckUb;
    protected double timeCheckPre;
    protected double timeCheckProb0;
    protected double timeRefine;
    protected double timeTotal;
    protected int itersTotal;
    protected int refinementNum;

    public QuantAbstractRefine(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        try {
            this.mcOptions = new ProbModelChecker(null);
        }
        catch (PrismException prismException) {
            // empty catch block
        }
    }

    public ProbModelChecker getModelChecker() {
        return this.mcOptions;
    }

    public void printSettings() {
        this.mainLog.print("\nAR Settings:");
        this.mainLog.print(" modelType = " + String.valueOf((Object)this.modelType));
        this.mainLog.print(" propertyType = " + String.valueOf((Object)this.propertyType));
        this.mainLog.print(" reachBound = " + this.reachBound);
        this.mainLog.print(" verbosity = " + this.verbosity);
        this.mainLog.print(" maxRefinements = " + this.maxRefinements);
        this.mainLog.print(" exportDot = " + this.exportDot);
        this.mainLog.print(" optimise = " + this.optimise);
        this.mainLog.print(" refineTermCrit = " + String.valueOf((Object)this.refineTermCrit));
        this.mainLog.print(" refineTermCritParam = " + this.refineTermCritParam);
        this.mainLog.print(" above = " + this.above);
        this.mainLog.print(" refineStratWhere = " + String.valueOf((Object)this.refineStratWhere));
        this.mainLog.print(" refineStratHow = " + String.valueOf((Object)this.refineStratHow));
        this.mainLog.println();
        this.mainLog.print("\nMC Settings: ");
        this.mcOptions.printSettings();
        this.mainLog.println();
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public void setReachBound(int n) {
        this.reachBound = n;
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
        if (this.mcOptions != null) {
            this.mcOptions.setVerbosity(n);
        }
    }

    public void setMaxRefinements(int n) {
        this.maxRefinements = n;
    }

    public void setExportDot(boolean bl) {
        this.exportDot = bl;
    }

    public void setOptimise(boolean bl) {
        this.optimise = bl;
    }

    public void setRefineTermCrit(RefineTermCrit refineTermCrit) {
        this.refineTermCrit = refineTermCrit;
    }

    public void setRefineTermCritParam(double d) {
        this.refineTermCritParam = d;
    }

    public void setAbove(boolean bl) {
        this.above = bl;
    }

    public void setRefineStratWhere(RefineStratWhere refineStratWhere) {
        this.refineStratWhere = refineStratWhere;
    }

    public void setRefineStratHow(RefineStratHow refineStratHow) {
        this.refineStratHow = refineStratHow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseOption(String string) throws PrismException {
        String string2;
        if ("".equals(string)) {
            return;
        }
        int n = string.indexOf(61);
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        } else {
            string2 = null;
        }
        if (string.equals("verbose") || string.equals("v")) {
            try {
                this.setVerbosity(string2 == null ? 10 : Integer.parseInt(string2));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismNotSupportedException("Invalid value \"" + string2 + "\" for abstraction-refinement setting \"" + string + "\"");
            }
        } else if (string.matches("refine")) {
            if (string2 == null) return;
            String[] stringArray = string2.split(",");
            if (stringArray.length > 0) {
                if (stringArray[0].equals("all")) {
                    this.setRefineStratWhere(RefineStratWhere.ALL);
                } else if (stringArray[0].equals("allmax")) {
                    this.setRefineStratWhere(RefineStratWhere.ALL_MAX);
                } else if (stringArray[0].equals("first")) {
                    this.setRefineStratWhere(RefineStratWhere.FIRST);
                } else if (stringArray[0].equals("firstmax")) {
                    this.setRefineStratWhere(RefineStratWhere.FIRST_MAX);
                } else if (stringArray[0].equals("last")) {
                    this.setRefineStratWhere(RefineStratWhere.LAST);
                } else {
                    if (!stringArray[0].equals("lastmax")) throw new PrismException("Unknown refinement option \"" + stringArray[0] + "\"");
                    this.setRefineStratWhere(RefineStratWhere.LAST_MAX);
                }
            }
            if (stringArray.length <= 1) return;
            if (stringArray[1].equals("all")) {
                this.setRefineStratHow(RefineStratHow.ALL);
                return;
            } else {
                if (!stringArray[1].equals("val")) throw new PrismException("Unknown refinement option \"" + stringArray[1] + "\"");
                this.setRefineStratHow(RefineStratHow.VAL);
            }
            return;
        } else if (string.equals("epsilonref") || string.equals("eref")) {
            if (string2 == null) return;
            try {
                this.setRefineTermCritParam(Double.parseDouble(string2));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value \"" + string2 + "\" for abstraction-refinement setting \"" + string + "\"");
            }
        } else if (string.equals("nopre")) {
            this.getModelChecker().setPrecomp(false);
            return;
        } else if (string.equals("pre")) {
            this.getModelChecker().setPrecomp(true);
            return;
        } else if (string.equals("noprob0")) {
            this.getModelChecker().setProb0(false);
            return;
        } else if (string.equals("noprob1")) {
            this.getModelChecker().setProb1(false);
            return;
        } else if (string.equals("epsilon")) {
            if (string2 == null) return;
            try {
                this.getModelChecker().setTermCritParam(Double.parseDouble(string2));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value \"" + string2 + "\" for abstraction-refinement setting \"" + string + "\"");
            }
        } else if (string.equals("maxrefs")) {
            if (string2 == null) return;
            try {
                this.setMaxRefinements(Integer.parseInt(string2));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value \"" + string2 + "\" for abstraction-refinement setting \"" + string + "\"");
            }
        } else if (string.equals("opt")) {
            this.setOptimise(true);
            return;
        } else if (string.equals("noopt")) {
            this.setOptimise(false);
            return;
        } else if (string.equals("exportdot")) {
            this.setExportDot(true);
            return;
        } else if (string.equals("above")) {
            this.setAbove(true);
            return;
        } else {
            if (!string.equals("below")) throw new PrismException("Unknown switch " + string);
            this.setAbove(false);
        }
    }

    public void parseOptions(String[] stringArray) throws PrismException {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                this.parseOption(string);
            }
        }
    }

    public static void printOptions(PrismLog prismLog) {
        prismLog.println(" * verbose=<n> (or v=<n>) - verbosity level");
        prismLog.println(" * refine=<where,how> - which states to refine and how");
        prismLog.println("     <where> = all, allmax, first, firstmax, last, lastmax");
        prismLog.println("     <how> = all, val");
        prismLog.println(" * epsilonref=<x> (or eref=<x>) - epsilon for refinement");
        prismLog.println(" * nopre  - disable precomputation");
        prismLog.println(" * pre - use precomputation");
        prismLog.println(" * noprob0 - disable prob0 precomputation");
        prismLog.println(" * noprob1 - disable prob1 precomputation");
        prismLog.println(" * epsilon=<x> - epsilon for numerical convergence");
        prismLog.println(" * maxref=<n> - maximum number of refinements");
        prismLog.println(" * opt - use optimisations");
        prismLog.println(" * noopt - disable optimisations");
        prismLog.println(" * exportdot - export dot files for each refinement");
        prismLog.println(" * above - start numerical soluton from above");
        prismLog.println(" * below - start numerical soluton from below");
    }

    protected abstract void initialise() throws PrismException;

    protected abstract int splitState(int var1, List<List<Integer>> var2, Set<Integer> var3, Set<Integer> var4) throws PrismException;

    protected abstract void rebuildAbstraction(Set<Integer> var1) throws PrismException;

    public double abstractRefine(boolean bl) throws PrismException {
        boolean bl2 = false;
        this.min = bl;
        if (this.modelType == ModelType.CTMC && this.propertyType == PropertyType.PROB_REACH) {
            this.buildEmbeddedDtmc = true;
            this.modelType = ModelType.DTMC;
        }
        switch (this.modelType) {
            case DTMC: {
                this.abstractionType = ModelType.MDP;
                this.mc = new MDPModelChecker(null);
                break;
            }
            case CTMC: {
                this.abstractionType = ModelType.CTMDP;
                this.mc = new CTMDPModelChecker(null);
                break;
            }
            case MDP: {
                this.abstractionType = ModelType.STPG;
                this.mc = new STPGModelChecker(null);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot handle model type " + String.valueOf((Object)this.modelType));
            }
        }
        this.mc.inheritSettings(this.mcOptions);
        long l = System.currentTimeMillis();
        this.timeRefine = 0.0;
        this.timeCheck = 0.0;
        this.timeRebuild = 0.0;
        this.timeBuild = 0.0;
        this.timeCheckProb0 = 0.0;
        this.timeCheckPre = 0.0;
        this.timeCheckUb = 0.0;
        this.timeCheckLb = 0.0;
        this.itersTotal = 0;
        this.mainLog.println("\nBuilding initial " + String.valueOf((Object)this.abstractionType) + "...");
        long l2 = System.currentTimeMillis();
        this.initialise();
        String string = this.abstraction.infoString();
        l2 = System.currentTimeMillis() - l2;
        this.timeBuild += (double)l2 / 1000.0;
        if (this.verbosity >= 2) {
            this.mainLog.println(String.valueOf((Object)this.abstractionType) + " constructed in " + (double)l2 / 1000.0 + " secs.");
            this.mainLog.println(String.valueOf((Object)this.abstractionType) + ": " + this.abstraction.infoString());
        }
        if (this.verbosity >= 10) {
            this.mainLog.println(String.valueOf((Object)this.abstractionType) + ": " + String.valueOf(this.abstraction));
        }
        int n = this.abstraction.getNumStates();
        this.lbSoln = Utils.bitsetToDoubleArray(this.target, n);
        this.ubSoln = new double[n];
        for (int i = 0; i < n; ++i) {
            this.ubSoln[i] = 1.0;
        }
        this.known = (BitSet)this.target.clone();
        this.refinementNum = 0;
        while (true) {
            if (this.exportDot) {
                QuantAbstractRefine.exportToDotFile("abstr" + this.refinementNum + ".dot", this.abstraction, this.known, this.lbSoln, this.ubSoln);
            }
            this.modelCheckAbstraction(bl);
            if (this.refinementNum >= this.maxRefinements || !(bl2 = this.chooseStatesToRefine())) break;
            ++this.refinementNum;
            this.refine(this.refineStates);
            if (this.verbosity < 10) continue;
            this.mainLog.println(String.valueOf((Object)this.abstractionType) + ": " + String.valueOf(this.abstraction));
        }
        l = System.currentTimeMillis() - l;
        this.timeTotal = (double)l / 1000.0;
        this.printFinalSummary(string, bl2);
        return (this.lbInit + this.ubInit) / 2.0;
    }

    protected int cheapCheckRefine() throws PrismException {
        if (this.propertyType != PropertyType.PROB_REACH) {
            return 0;
        }
        this.mainLog.println("cheap...");
        int n = this.abstraction.getNumStates();
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            int n4 = n3 = this.known == null ? n3 + 1 : this.known.nextClearBit(n3 + 1);
            if (n3 < 0) break;
            if (!((STPG)((Object)this.abstraction)).allSuccessorsInSet(n3, this.known)) continue;
            double d = ((STPG)((Object)this.abstraction)).mvMultMinMaxSingle(n3, this.lbSoln, true, this.min);
            double d2 = ((STPG)((Object)this.abstraction)).mvMultMinMaxSingle(n3, this.lbSoln, false, this.min);
            this.mainLog.println(((STPGAbstrSimple)this.abstraction).getChoices(n3));
            this.mainLog.println("XX " + n3 + ": old=[" + this.lbSoln[n3] + "," + this.ubSoln[n3] + "], new=[" + d + "," + d2 + "]");
            if (PrismUtils.doublesAreClose(d2, d, this.refineTermCritParam, this.refineTermCrit == RefineTermCrit.ABSOLUTE)) {
                this.lbSoln[n3] = this.ubSoln[n3] = d;
                this.known.set(n3);
                ++n2;
                continue;
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            long l = System.currentTimeMillis();
            int n5 = this.refineState(n3, null, hashSet);
            l = System.currentTimeMillis() - l;
            this.timeRefine += (double)l / 1000.0;
            if (n5 <= 1) continue;
            l = System.currentTimeMillis();
            this.rebuildAbstraction(hashSet);
            l = System.currentTimeMillis() - l;
            this.timeRebuild += (double)l / 1000.0;
            this.mainLog.println("rebuildStates: " + String.valueOf(hashSet));
            ++n2;
            for (int i = 0; i < n5; ++i) {
                int n6 = i == 0 ? n3 : this.abstraction.getNumStates() - n5 + i;
                d = ((STPG)((Object)this.abstraction)).mvMultMinMaxSingle(n6, this.lbSoln, true, this.min);
                d2 = ((STPG)((Object)this.abstraction)).mvMultMinMaxSingle(n6, this.lbSoln, false, this.min);
                this.mainLog.println("XXX " + n6 + ": old=[" + this.lbSoln[n6] + "," + this.ubSoln[n6] + "], new=[" + d + "," + d2 + "]");
                this.lbSoln[n6] = this.lbLastSoln[n6] = d;
                this.ubSoln[n6] = this.ubLastSoln[n6] = d2;
                if (!PrismUtils.doublesAreClose(d2, d, this.refineTermCritParam, this.refineTermCrit == RefineTermCrit.ABSOLUTE)) continue;
                this.lbSoln[n6] = this.ubSoln[n6] = d;
                this.known.set(n6);
                ++n2;
            }
        }
        return n2;
    }

    protected void modelCheckAbstraction(boolean bl) throws PrismException {
        this.mainLog.println("\nModel checking " + String.valueOf((Object)this.abstractionType) + "...");
        long l = System.currentTimeMillis();
        switch (this.propertyType.ordinal()) {
            case 0: {
                this.modelCheckAbstractionProbReach(bl);
                break;
            }
            case 2: {
                this.modelCheckAbstractionReachBounded(bl);
                break;
            }
            case 1: {
                this.modelCheckAbstractionExpReach(bl);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Property type " + String.valueOf((Object)this.propertyType) + " not supported");
            }
        }
        int n = this.abstraction.getNumStates();
        for (int i = 0; i < n; ++i) {
            this.known.set(i, PrismUtils.doublesAreClose(this.ubSoln[i], this.lbSoln[i], this.refineTermCritParam, this.refineTermCrit == RefineTermCrit.ABSOLUTE));
        }
        this.ubInit = bl ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        this.lbInit = this.ubInit;
        for (int n2 : this.abstraction.getInitialStates()) {
            if (this.verbosity >= 10) {
                this.mainLog.println("Init " + n2 + ": " + this.lbSoln[n2] + "-" + this.ubSoln[n2]);
            }
            if (bl) {
                this.lbInit = Math.min(this.lbInit, this.lbSoln[n2]);
                this.ubInit = Math.min(this.ubInit, this.ubSoln[n2]);
                continue;
            }
            this.lbInit = Math.max(this.lbInit, this.lbSoln[n2]);
            this.ubInit = Math.max(this.ubInit, this.ubSoln[n2]);
        }
        l = System.currentTimeMillis() - l;
        this.timeCheck += (double)l / 1000.0;
        this.mainLog.println(String.valueOf((Object)this.abstractionType) + " model checked in " + (double)l / 1000.0 + " secs.");
        this.mainLog.println(this.known.cardinality() + "/" + n + " states converged.");
        int n3 = this.abstraction.getNumInitialStates();
        this.mainLog.print("Diff across ");
        this.mainLog.print(n3 + " initial state" + (n3 == 1 ? "" : "s") + ": ");
        this.mainLog.println(this.ubInit - this.lbInit);
        this.mainLog.print("Lower/upper bounds for ");
        this.mainLog.print(n3 + " initial state" + (n3 == 1 ? "" : "s") + ": ");
        this.mainLog.println(this.lbInit + " - " + this.ubInit);
    }

    protected void modelCheckAbstractionProbReach(boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        switch (this.abstractionType) {
            case MDP: {
                if (this.optimise && this.refinementNum > 0) {
                    this.mc.setValIterDir(ProbModelChecker.ValIterDir.BELOW);
                    break;
                }
                modelCheckerResult = ((MDPModelChecker)this.mc).computeReachProbs((MDP)((Object)this.abstraction), this.target, true);
                break;
            }
            case CTMDP: {
                if (this.optimise && this.refinementNum > 0) {
                    this.mc.setValIterDir(ProbModelChecker.ValIterDir.BELOW);
                    break;
                }
                modelCheckerResult = ((CTMDPModelChecker)this.mc).computeReachProbs((CTMDP)((Object)this.abstraction), this.target, true);
                break;
            }
            case STPG: {
                if (this.optimise && this.refinementNum > 0) {
                    this.mc.setValIterDir(ProbModelChecker.ValIterDir.BELOW);
                    modelCheckerResult = ((STPGModelChecker)this.mc).computeReachProbs((STPG)((Object)this.abstraction), null, this.target, true, bl, this.lbSoln, this.known);
                    break;
                }
                modelCheckerResult = ((STPGModelChecker)this.mc).computeReachProbs((STPG)((Object)this.abstraction), null, this.target, true, bl, null, null);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + String.valueOf((Object)this.abstractionType));
            }
        }
        this.lbSoln = modelCheckerResult.soln;
        this.lbLastSoln = this.lbSoln;
        this.timeCheckLb += modelCheckerResult.timeTaken;
        this.timeCheckProb0 += modelCheckerResult.timeProb0;
        this.timeCheckPre += modelCheckerResult.timePre;
        this.itersTotal += modelCheckerResult.numIters;
        switch (this.abstractionType) {
            case MDP: {
                if (this.optimise) break;
                modelCheckerResult = ((MDPModelChecker)this.mc).computeReachProbs((MDP)((Object)this.abstraction), this.target, false);
                break;
            }
            case CTMDP: {
                if (this.optimise) break;
                modelCheckerResult = ((CTMDPModelChecker)this.mc).computeReachProbs((CTMDP)((Object)this.abstraction), this.target, false);
                break;
            }
            case STPG: {
                if (this.optimise) {
                    if (this.above) {
                        this.mc.setValIterDir(ProbModelChecker.ValIterDir.ABOVE);
                        modelCheckerResult = ((STPGModelChecker)this.mc).computeReachProbs((STPG)((Object)this.abstraction), null, this.target, false, bl, this.ubSoln, this.known);
                        break;
                    }
                    this.mc.setValIterDir(ProbModelChecker.ValIterDir.BELOW);
                    double[] dArray = Utils.cloneDoubleArray(this.lbSoln);
                    modelCheckerResult = ((STPGModelChecker)this.mc).computeReachProbs((STPG)((Object)this.abstraction), null, this.target, false, bl, dArray, this.known);
                    break;
                }
                modelCheckerResult = ((STPGModelChecker)this.mc).computeReachProbs((STPG)((Object)this.abstraction), null, this.target, false, bl, null, null);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + String.valueOf((Object)this.abstractionType));
            }
        }
        this.ubSoln = modelCheckerResult.soln;
        this.ubLastSoln = this.ubSoln;
        this.timeCheckUb += modelCheckerResult.timeTaken;
        this.timeCheckProb0 += modelCheckerResult.timeProb0;
        this.timeCheckPre += modelCheckerResult.timePre;
        this.itersTotal += modelCheckerResult.numIters;
    }

    protected void modelCheckAbstractionReachBounded(boolean bl) throws PrismException {
        int n;
        ModelCheckerResult modelCheckerResult;
        double[] dArray = new double[this.reachBound + 1];
        switch (this.abstractionType) {
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this.mc).computeBoundedReachProbs((MDP)((Object)this.abstraction), null, this.target, this.reachBound, true, null, dArray);
                break;
            }
            case CTMDP: {
                modelCheckerResult = ((CTMDPModelChecker)this.mc).computeBoundedReachProbs((CTMDP)((Object)this.abstraction), null, this.target, this.reachBound, true, null, dArray);
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this.mc).computeBoundedReachProbs((STPG)((Object)this.abstraction), null, this.target, this.reachBound, true, bl, null, dArray);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + String.valueOf((Object)this.abstractionType));
            }
        }
        this.lbSoln = modelCheckerResult.soln;
        this.lbLastSoln = modelCheckerResult.lastSoln;
        this.timeCheckLb += modelCheckerResult.timeTaken;
        this.timeCheckProb0 += modelCheckerResult.timeProb0;
        this.timeCheckPre += modelCheckerResult.timePre;
        this.itersTotal += modelCheckerResult.numIters;
        this.mainLog.print("#");
        for (n = 0; n < this.reachBound + 1; ++n) {
            this.mainLog.print(" " + dArray[n]);
        }
        this.mainLog.println();
        switch (this.abstractionType) {
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this.mc).computeBoundedReachProbs((MDP)((Object)this.abstraction), null, this.target, this.reachBound, false, null, dArray);
                break;
            }
            case CTMDP: {
                modelCheckerResult = ((CTMDPModelChecker)this.mc).computeBoundedReachProbs((CTMDP)((Object)this.abstraction), null, this.target, this.reachBound, false, null, dArray);
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this.mc).computeBoundedReachProbs((STPG)((Object)this.abstraction), null, this.target, this.reachBound, false, bl, null, dArray);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + String.valueOf((Object)this.abstractionType));
            }
        }
        this.ubSoln = modelCheckerResult.soln;
        this.ubLastSoln = modelCheckerResult.lastSoln;
        this.timeCheckUb += modelCheckerResult.timeTaken;
        this.timeCheckProb0 += modelCheckerResult.timeProb0;
        this.timeCheckPre += modelCheckerResult.timePre;
        this.itersTotal += modelCheckerResult.numIters;
        this.mainLog.print("#");
        for (n = 0; n < this.reachBound + 1; ++n) {
            this.mainLog.print(" " + dArray[n]);
        }
        this.mainLog.println();
    }

    protected void modelCheckAbstractionExpReach(boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        this.mc.termCrit = ProbModelChecker.TermCrit.RELATIVE;
        this.mc.termCritParam = 1.0E-8;
        switch (this.abstractionType) {
            case MDP: {
                if (this.optimise && this.refinementNum > 0) {
                    modelCheckerResult = ((MDPModelChecker)this.mc).computeReachRewards((MDP)((Object)this.abstraction), null, this.target, true, this.lbSoln, this.known);
                    break;
                }
                modelCheckerResult = ((MDPModelChecker)this.mc).computeReachRewards((MDP)((Object)this.abstraction), null, this.target, true, null, null);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + String.valueOf((Object)this.abstractionType));
            }
        }
        this.lbSoln = modelCheckerResult.soln;
        this.lbLastSoln = this.lbSoln;
        this.timeCheckLb += modelCheckerResult.timeTaken;
        this.timeCheckProb0 += modelCheckerResult.timeProb0;
        this.timeCheckPre += modelCheckerResult.timePre;
        this.itersTotal += modelCheckerResult.numIters;
        switch (this.abstractionType) {
            case MDP: {
                if (this.optimise) {
                    double[] dArray = Utils.cloneDoubleArray(this.lbSoln);
                    modelCheckerResult = ((MDPModelChecker)this.mc).computeReachRewards((MDP)((Object)this.abstraction), null, this.target, false, dArray, this.known);
                    break;
                }
                modelCheckerResult = ((MDPModelChecker)this.mc).computeReachRewards((MDP)((Object)this.abstraction), null, this.target, false, null, null);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + String.valueOf((Object)this.abstractionType));
            }
        }
        this.ubSoln = modelCheckerResult.soln;
        this.ubLastSoln = this.ubSoln;
        this.timeCheckUb += modelCheckerResult.timeTaken;
        this.timeCheckProb0 += modelCheckerResult.timeProb0;
        this.timeCheckPre += modelCheckerResult.timePre;
        this.itersTotal += modelCheckerResult.numIters;
    }

    protected boolean chooseStatesToRefine() throws PrismException {
        double d;
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.refineStates = new ArrayList<Integer>();
        if (PrismUtils.doublesAreClose(this.ubInit, this.lbInit, this.refineTermCritParam, this.refineTermCrit == RefineTermCrit.ABSOLUTE)) {
            return false;
        }
        int n2 = this.abstraction.getNumStates();
        double d2 = this.ubSoln[0] - this.lbSoln[0];
        for (n = 1; n < n2; ++n) {
            if (!(this.ubSoln[n] - this.lbSoln[n] > d2)) continue;
            d2 = this.ubSoln[n] - this.lbSoln[n];
        }
        this.mainLog.println("Max diff over all states: " + d2);
        switch (this.refineStratWhere.ordinal()) {
            case 1: 
            case 3: 
            case 5: {
                d = Math.max(0.0, d2 - this.refineTermCritParam);
                break;
            }
            default: {
                d = this.refineTermCritParam;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!(this.ubSoln[n] - this.lbSoln[n] >= d) || this.abstraction.getNumChoices(n) <= 1) continue;
            arrayList.add(n);
        }
        this.mainLog.println(arrayList.size() + " refineable states.");
        if (this.verbosity >= 1) {
            this.mainLog.println("Refinable states: " + String.valueOf(arrayList));
        }
        if (arrayList.size() == 0) {
            return false;
        }
        switch (this.refineStratWhere.ordinal()) {
            case 0: 
            case 1: {
                this.refineStates.addAll(arrayList);
                break;
            }
            case 2: 
            case 3: {
                this.refineStates.add((Integer)arrayList.get(0));
                break;
            }
            case 4: 
            case 5: {
                this.refineStates.add((Integer)arrayList.get(arrayList.size() - 1));
                break;
            }
            default: {
                throw new PrismException("Unknown (where) refinement strategy \"" + this.refineStratWhere.name() + "\"");
            }
        }
        return true;
    }

    protected void refine(List<Integer> list) throws PrismException {
        this.mainLog.println("\nRefinement " + this.refinementNum + "...");
        long l = System.currentTimeMillis();
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> linkedHashSet2 = new LinkedHashSet<Integer>();
        int n = 0;
        int n2 = list.size();
        for (int i = n2 - 1; i >= 0; --i) {
            int n3;
            int n4;
            if (this.verbosity >= 1) {
                this.mainLog.println("Refinement " + this.refinementNum + "." + (n2 - i) + "...");
            }
            if ((n4 = this.refineState(n3 = list.get(i).intValue(), linkedHashSet, linkedHashSet2)) <= 1) continue;
            ++n;
        }
        l = System.currentTimeMillis() - l;
        this.timeRefine += (double)l / 1000.0;
        this.mainLog.print(n + " states successfully refined");
        this.mainLog.println(" in " + (double)l / 1000.0 + " secs.");
        l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Rebuilding states: " + String.valueOf(linkedHashSet2));
        }
        this.rebuildAbstraction(linkedHashSet2);
        l = System.currentTimeMillis() - l;
        this.timeRebuild += (double)l / 1000.0;
        this.mainLog.print(linkedHashSet.size() + "+" + linkedHashSet2.size() + "=");
        this.mainLog.print(linkedHashSet.size() + linkedHashSet2.size());
        this.mainLog.println(" states of " + String.valueOf((Object)this.abstractionType) + " rebuilt in " + (double)l / 1000.0 + " secs.");
        this.mainLog.println("New " + String.valueOf((Object)this.abstractionType) + " has " + this.abstraction.getNumStates() + " states.");
    }

    protected int refineState(int n, Set<Integer> set, Set<Integer> set2) throws PrismException {
        List<Integer> list = null;
        List<Integer> list2 = null;
        if (this.sanityChecks) {
            if (this.target.get(n)) {
                throw new PrismException("Why would I want to refine a target state?");
            }
            if (this.known.get(n)) {
                throw new PrismException("Why would I want to refine a state that has already converged?");
            }
        }
        if (set.contains(n)) {
            if (this.verbosity >= 1) {
                this.mainLog.printWarning("Skipping refinement of #" + n + " which has already been modified by refinement.");
            }
            return 1;
        }
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        switch (this.refineStratHow.ordinal()) {
            case 1: {
                list2 = null;
                list = null;
                switch (this.abstractionType) {
                    case MDP: {
                        switch (this.propertyType.ordinal()) {
                            case 0: {
                                list = ((MDPModelChecker)this.mc).probReachStrategy((MDP)((Object)this.abstraction), n, this.target, true, this.lbLastSoln);
                                list2 = ((MDPModelChecker)this.mc).probReachStrategy((MDP)((Object)this.abstraction), n, this.target, false, this.ubLastSoln);
                                break;
                            }
                            case 2: {
                                list = ((MDPModelChecker)this.mc).probReachStrategy((MDP)((Object)this.abstraction), n, this.target, true, this.lbLastSoln);
                                list2 = ((MDPModelChecker)this.mc).probReachStrategy((MDP)((Object)this.abstraction), n, this.target, false, this.ubLastSoln);
                                break;
                            }
                            case 1: {
                                list = ((MDPModelChecker)this.mc).expReachStrategy((MDP)((Object)this.abstraction), null, n, this.target, true, this.lbLastSoln);
                                list2 = ((MDPModelChecker)this.mc).expReachStrategy((MDP)((Object)this.abstraction), null, n, this.target, false, this.ubLastSoln);
                            }
                        }
                        break;
                    }
                    case CTMDP: {
                        list = ((CTMDPModelChecker)this.mc).probReachStrategy((CTMDP)((Object)this.abstraction), n, this.target, true, this.lbLastSoln);
                        list2 = ((CTMDPModelChecker)this.mc).probReachStrategy((CTMDP)((Object)this.abstraction), n, this.target, false, this.ubLastSoln);
                        break;
                    }
                    case STPG: {
                        list = ((STPGModelChecker)this.mc).probReachStrategy((STPG)((Object)this.abstraction), n, this.target, true, this.min, this.lbLastSoln);
                        list2 = ((STPGModelChecker)this.mc).probReachStrategy((STPG)((Object)this.abstraction), n, this.target, false, this.min, this.ubLastSoln);
                    }
                }
                if (list == null || list2 == null) {
                    Object object = "Cannot generate strategy information for";
                    object = (String)object + " model type " + String.valueOf((Object)this.abstractionType) + " and property type " + String.valueOf((Object)this.propertyType);
                    throw new PrismException((String)object);
                }
                if (this.sanityChecks && (list.isEmpty() || list2.isEmpty())) {
                    throw new PrismException("Empty strategy generated for state " + n);
                }
                if (list.equals(list2) && list.size() == this.abstraction.getNumChoices(n)) {
                    if (this.verbosity >= 1) {
                        this.mainLog.printWarning("Skipping refinement of #" + n + " for which lb/ub strategy sets are equal and covering.");
                    }
                    return 1;
                }
                if (this.verbosity >= 1) {
                    this.mainLog.println("lbStrat: " + String.valueOf(list) + ", ubStrat: " + String.valueOf(list2));
                }
                int n2 = 1;
                switch (n2) {
                    case 1: {
                        if (list.containsAll(list2)) {
                            list.removeAll(list2);
                        } else {
                            list2.removeAll(list);
                        }
                        if (!list.isEmpty()) {
                            arrayList.add(list);
                        }
                        if (list2.isEmpty()) break;
                        arrayList.add(list2);
                        break;
                    }
                    case 2: {
                        list.removeAll(list2);
                        list2.removeAll(list);
                        arrayList.add(list);
                        arrayList.add(list2);
                        break;
                    }
                    case 3: {
                        if (list.containsAll(list2)) {
                            list.removeAll(list2);
                        } else {
                            list2.removeAll(list);
                        }
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                        arrayList2.add(list.get(0));
                        arrayList.add(arrayList2);
                        arrayList2 = new ArrayList();
                        arrayList2.add(list2.get(0));
                        arrayList.add(arrayList2);
                    }
                }
                if (this.verbosity < 1) break;
                this.mainLog.println("split: " + String.valueOf(arrayList));
                break;
            }
            case 0: {
                int n3 = this.abstraction.getNumChoices(n);
                for (int i = 0; i < n3; ++i) {
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    arrayList3.add(i);
                    arrayList.add(arrayList3);
                }
                break;
            }
            default: {
                throw new PrismException("Unknown (how) refinement strategy \"" + this.refineStratWhere.name() + "\"");
            }
        }
        int n4 = this.abstraction.getNumStates();
        int n5 = this.splitState(n, arrayList, set, set2);
        this.lbSoln = Utils.extendDoubleArray(this.lbSoln, n4, n4 + n5 - 1, this.lbSoln[n]);
        this.lbLastSoln = Utils.extendDoubleArray(this.lbLastSoln, n4, n4 + n5 - 1, this.lbLastSoln[n]);
        this.ubSoln = Utils.extendDoubleArray(this.ubSoln, n4, n4 + n5 - 1, this.ubSoln[n]);
        this.ubLastSoln = Utils.extendDoubleArray(this.ubLastSoln, n4, n4 + n5 - 1, this.ubLastSoln[n]);
        return n5;
    }

    public void addRemainderIntoChoiceLists(int n, List<List<Integer>> list) {
        int n2 = this.abstraction.getNumChoices(n);
        BitSet bitSet = new BitSet(n2);
        for (List<Integer> list2 : list) {
            for (int n3 : list2) {
                bitSet.set(n3);
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = bitSet.nextClearBit(0);
        while (n4 < n2) {
            arrayList.add(n4);
            n4 = bitSet.nextClearBit(n4 + 1);
        }
        if (arrayList.size() > 0) {
            list.add(arrayList);
        }
    }

    protected void printFinalSummary(String string, boolean bl) {
        this.mainLog.println("\nInitial " + String.valueOf((Object)this.abstractionType) + ": " + string);
        this.mainLog.println("Final " + String.valueOf((Object)this.abstractionType) + ": " + this.abstraction.infoString());
        this.mainLog.print("\nTerminated " + (bl ? "(early) " : ""));
        this.mainLog.print("after " + this.refinementNum + " refinements");
        this.mainLog.print(" in " + PrismUtils.formatDouble2dp(this.timeTotal) + " secs.");
        this.mainLog.println();
        this.mainLog.println("\nAbstraction-refinement time breakdown:");
        this.mainLog.print("* " + PrismUtils.formatDouble2dp(this.timeBuild) + " secs");
        this.mainLog.print(" (" + PrismUtils.formatPercent1dp(this.timeBuild / this.timeTotal) + ")");
        this.mainLog.print(" = Building initial " + String.valueOf((Object)this.abstractionType));
        this.mainLog.println();
        this.mainLog.print("* " + PrismUtils.formatDouble2dp(this.timeRebuild) + " secs");
        this.mainLog.print(" (" + PrismUtils.formatPercent1dp(this.timeRebuild / this.timeTotal) + ")");
        this.mainLog.print(" = Rebuilding " + String.valueOf((Object)this.abstractionType) + " (");
        this.mainLog.print(this.refinementNum + " x avg " + PrismUtils.formatDouble2dp(this.refinementNum > 0 ? this.timeRebuild / (double)this.refinementNum : 0.0) + " secs)");
        this.mainLog.println();
        this.mainLog.print("* " + PrismUtils.formatDouble2dp(this.timeCheck) + " secs");
        this.mainLog.print(" (" + PrismUtils.formatPercent1dp(this.timeCheck / this.timeTotal) + ")");
        this.mainLog.print(" = model checking " + String.valueOf((Object)this.abstractionType) + " (" + (this.refinementNum + 1) + " x avg ");
        this.mainLog.print(PrismUtils.formatDouble2dp(this.timeCheck / (double)(this.refinementNum + 1)) + " secs)");
        this.mainLog.print(" (lb=" + PrismUtils.formatPercent1dp(this.timeCheckLb / (this.timeCheckLb + this.timeCheckUb)) + ")");
        this.mainLog.print(" (prob0=" + PrismUtils.formatPercent1dp(this.timeCheckProb0 / this.timeCheck) + ")");
        this.mainLog.print(" (pre=" + PrismUtils.formatPercent1dp(this.timeCheckPre / this.timeCheck) + ")");
        this.mainLog.print(" (iters=" + this.itersTotal + ")");
        this.mainLog.println();
        this.mainLog.print("* " + PrismUtils.formatDouble2dp(this.timeRefine) + " secs");
        this.mainLog.print(" (" + PrismUtils.formatPercent1dp(this.timeRefine / this.timeTotal) + ")");
        this.mainLog.print(" = refinement (");
        this.mainLog.print(this.refinementNum + " x avg " + PrismUtils.formatDouble2dp(this.refinementNum > 0 ? this.timeRefine / (double)this.refinementNum : 0.0) + " secs)");
        this.mainLog.println();
        int n = this.abstraction.getNumInitialStates();
        this.mainLog.print("\nFinal diff across ");
        this.mainLog.print(n + " initial state" + (n == 1 ? "" : "s") + ": ");
        this.mainLog.println(this.ubInit - this.lbInit);
        this.mainLog.print("Final lower/upper bounds for ");
        this.mainLog.print(n + " initial state" + (n == 1 ? "" : "s") + ": ");
        this.mainLog.println(this.lbInit + " - " + this.ubInit);
    }

    private static void exportToDotFile(String string, Model model, BitSet bitSet, double[] dArray, double[] dArray2) throws PrismException {
        STPGAbstrSimple sTPGAbstrSimple;
        if (model instanceof STPG) {
            sTPGAbstrSimple = (STPGAbstrSimple)model;
        } else if (model instanceof MDPSimple) {
            sTPGAbstrSimple = new STPGAbstrSimple((MDPSimple)model);
        } else {
            throw new PrismNotSupportedException("Cannot export this model type to a dot file");
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("digraph STPG {\nnode [shape=box];\n");
            for (int i = 0; i < sTPGAbstrSimple.getNumStates(); ++i) {
                if (bitSet.get(i)) {
                    fileWriter.write(i + " [label=\"" + i + " {" + dArray[i] + "}\" style=filled  fillcolor=\"#cccccc\"");
                } else {
                    fileWriter.write(i + " [label=\"" + i + " [" + (dArray2[i] - dArray[i]) + "]\"");
                }
                fileWriter.write("]\n");
                int n = -1;
                for (DistributionSet distributionSet : sTPGAbstrSimple.getChoices(i)) {
                    String string2 = "n" + i + "_" + ++n;
                    fileWriter.write(i + " -> " + string2 + " [ arrowhead=none,label=\"" + n + "\" ];\n");
                    fileWriter.write(string2 + " [ shape=circle,width=0.1,height=0.1,label=\"\" ];\n");
                    int n2 = -1;
                    for (Distribution distribution : distributionSet) {
                        String string3 = "n" + i + "_" + n + "_" + ++n2;
                        fileWriter.write(string2 + " -> " + string3 + " [ arrowhead=none,label=\"" + n2 + "\" ];\n");
                        fileWriter.write(string3 + " [ shape=point,label=\"\" ];\n");
                        for (Map.Entry entry : distribution) {
                            fileWriter.write(string3 + " -> " + String.valueOf(entry.getKey()) + " [ label=\"" + String.valueOf(entry.getValue()) + "\" ];\n");
                        }
                    }
                }
            }
            fileWriter.write("}\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Could not write abstraction to file \"" + string + "\"" + String.valueOf(iOException));
        }
    }

    public static enum RefineTermCrit {
        ABSOLUTE,
        RELATIVE;

    }

    public static enum RefineStratWhere {
        ALL,
        ALL_MAX,
        FIRST,
        FIRST_MAX,
        LAST,
        LAST_MAX;

    }

    public static enum RefineStratHow {
        ALL,
        VAL;

    }

    public static enum PropertyType {
        PROB_REACH,
        EXP_REACH,
        PROB_REACH_BOUNDED;

    }
}

