/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import dv.DoubleVector;
import java.util.HashMap;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public class ExportIterations {
    private static String defaultFilename = "iterations.html";
    private PrismLog log;
    private static HashMap<String, Integer> counts = new HashMap();

    public ExportIterations(String string) throws PrismException {
        this(string, PrismFileLog.create(defaultFilename));
    }

    public ExportIterations(String string, PrismLog prismLog) {
        this.log = prismLog;
        prismLog.println("<!DOCTYPE html>");
        prismLog.println("<html><head>");
        prismLog.println("<meta charset=\"utf-8\">");
        prismLog.println("<!-- HTML file automatically generated by the PRISM model checker -->");
        prismLog.println("<!-- For visualising the individual steps of a value iteration computation -->");
        prismLog.println("<!-- Loads supporting Javascript and CSS from www.prismmodelchecker.org -->");
        prismLog.println("<title>" + string + "</title>");
        prismLog.println("<link rel='stylesheet' href='https://www.prismmodelchecker.org/js/res/iteration-vis-v1.css'>");
        prismLog.println("<script src=\"https://www.prismmodelchecker.org/js/res/d3.js-v4/d3.min.js\"></script>");
        prismLog.println("<body onload='init();'>");
        prismLog.println("<h1>" + string + "</h1>");
        prismLog.println("<svg></svg>");
        prismLog.println("<script src=\"https://www.prismmodelchecker.org/js/res/iteration-vis-v1.js\"></script>");
        prismLog.flush();
    }

    public String getFileName() {
        if (this.log instanceof PrismFileLog) {
            return ((PrismFileLog)this.log).getFileName();
        }
        return null;
    }

    public void exportVector(double[] dArray) {
        this.exportVector(dArray, 0);
    }

    public void exportVector(double[] dArray, int n) {
        this.log.print("<script>addVector([");
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                this.log.print(",");
            }
            double d = dArray[i];
            this.exportValue(d);
        }
        this.log.print("]," + n + ")</script>\n");
        this.log.flush();
    }

    public void exportVector(DoubleVector doubleVector) {
        this.exportVector(doubleVector, 0);
    }

    public void exportVector(DoubleVector doubleVector, int n) {
        this.log.print("<script>addVector([");
        int n2 = doubleVector.getSize();
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                this.log.print(",");
            }
            double d = doubleVector.getElement(i);
            this.exportValue(d);
        }
        this.log.print("]," + n + ")</script>\n");
        this.log.flush();
    }

    private void exportValue(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            this.log.print("Infinity");
        } else if (d == Double.NEGATIVE_INFINITY) {
            this.log.print("-Infinity");
        } else {
            this.log.print(d);
        }
    }

    public void close() {
        this.log.println("\n</body></html>");
        this.log.flush();
    }

    public static String getUniqueFilename(String string) {
        int n = counts.getOrDefault(string, 0);
        counts.put(string, n + 1);
        return string + "-" + n + ".html";
    }

    public static ExportIterations createWithUniqueFilename(String string, String string2) throws PrismException {
        return new ExportIterations(string, PrismFileLog.create(ExportIterations.getUniqueFilename(string2)));
    }

    public static void setDefaultFilename(String string) {
        defaultFilename = string;
    }

    public static String getDefaultFilename() {
        return defaultFilename;
    }

    public static void resetDefaultFilename() {
        defaultFilename = "iterations.html";
    }
}

