/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.OptionalInt;

public class Range
implements FunctionalPrimitiveIterable.OfInt {
    protected final int first;
    protected final int last;
    protected final int step;

    public static Range closed(int n) {
        return Range.closed(0, n, 1);
    }

    public static Range closed(int n, int n2) {
        return Range.closed(n, n2, 1);
    }

    public static Range closed(int n, int n2, int n3) {
        return new Range(n, n2, n3, true);
    }

    public Range(int n) {
        this(0, n);
    }

    public Range(int n, int n2) {
        this(n, n2, 1);
    }

    public Range(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    private Range(int n, int n2, int n3, boolean bl) {
        if (n3 == 0) {
            throw new IllegalArgumentException("Expected: step != 0");
        }
        if (!bl) {
            n2 = Math.addExact(n2, n3 > 0 ? -1 : 1);
        }
        long l = (long)n2 - (long)n;
        if (n3 > 0 && l < 0L || n3 < 0 && l > 0L) {
            this.first = 0;
            this.last = -1;
            this.step = 1;
        } else {
            this.first = n;
            this.last = (int)((long)n + l / (long)n3 * (long)n3);
            this.step = this.first == this.last ? 1 : n3;
        }
        this.checkForOverAndUnderflows();
    }

    private void checkForOverAndUnderflows() {
        if (this.isAscending()) {
            if (this.last + this.step < this.last) {
                throw new ArithmeticException("integer overflow");
            }
        } else if (this.last + this.step > this.last) {
            throw new ArithmeticException("integer underflow");
        }
    }

    public boolean isAscending() {
        return this.step > 0;
    }

    public boolean isSingleton() {
        return this.first == this.last;
    }

    public Range reversed() {
        return new Range(this.last, this.first, -this.step, true);
    }

    @Override
    public RangeIterator iterator() {
        if (this.isAscending()) {
            return new AscendingRangeIterator();
        }
        return new DescendingRangeIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.isAscending() && this.first > this.last;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ".closed(" + this.first + ", " + this.last + ", " + this.step + ")";
    }

    public int hashCode() {
        int n = 1;
        if (this.isEmpty()) {
            return n;
        }
        n = 31 * n + this.first;
        n = 31 * n + this.last;
        n = 31 * n + this.step;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (this.first != range.first) {
            return false;
        }
        if (this.last != range.last) {
            return false;
        }
        return this.step == range.step;
    }

    protected class AscendingRangeIterator
    extends RangeIterator {
        public AscendingRangeIterator() {
            assert (Range.this.step > 0) : "Expected: step > 0";
        }

        @Override
        public boolean hasNext() {
            return this.next <= Range.this.last;
        }

        @Override
        public boolean contains(int n) {
            boolean bl = n >= this.next && n <= Range.this.last;
            boolean bl2 = bl && ((long)n - (long)this.next) % (long)Range.this.step == 0L;
            this.release();
            return bl2;
        }

        @Override
        public OptionalInt max() {
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            OptionalInt optionalInt = OptionalInt.of(Range.this.last);
            this.release();
            return optionalInt;
        }

        @Override
        public OptionalInt min() {
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            OptionalInt optionalInt = OptionalInt.of(this.next);
            this.release();
            return optionalInt;
        }
    }

    protected class DescendingRangeIterator
    extends RangeIterator {
        public DescendingRangeIterator() {
            assert (Range.this.step < 0) : "Expected: step < 0";
        }

        @Override
        public boolean hasNext() {
            return this.next >= Range.this.last;
        }

        @Override
        public boolean contains(int n) {
            boolean bl = n <= this.next && n >= Range.this.last;
            boolean bl2 = bl && ((long)n - (long)this.next) % (long)Range.this.step == 0L;
            this.release();
            return bl2;
        }

        @Override
        public OptionalInt max() {
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            OptionalInt optionalInt = OptionalInt.of(this.next);
            this.release();
            return optionalInt;
        }

        @Override
        public OptionalInt min() {
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            OptionalInt optionalInt = OptionalInt.of(Range.this.last);
            this.release();
            return optionalInt;
        }
    }

    public abstract class RangeIterator
    implements FunctionalPrimitiveIterator.OfInt {
        protected int next;

        public RangeIterator() {
            assert (Range.this.step != 0) : "Expected: step != 0";
            this.next = Range.this.first;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            int n = this.next;
            this.next += Range.this.step;
            return n;
        }

        @Override
        public long count() {
            if (!this.hasNext()) {
                return 0L;
            }
            long l = ((long)Range.this.last - (long)this.next) / (long)Range.this.step + 1L;
            this.release();
            return l;
        }

        @Override
        public long sum() {
            if (!this.hasNext()) {
                return 0L;
            }
            long l = this.next;
            long l2 = this.count();
            long l3 = l2 * (2L * l + (l2 - 1L) * (long)Range.this.step) / 2L;
            this.release();
            return l3;
        }

        @Override
        public void release() {
            this.next = Range.this.last + Range.this.step;
        }
    }
}

