/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigDecimal;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DecGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigDecimal> fac;
    GenPolynomial<BigDecimal> a;
    GenPolynomial<BigDecimal> b;
    GenPolynomial<BigDecimal> c;
    GenPolynomial<BigDecimal> d;
    GenPolynomial<BigDecimal> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DecGenPolynomialTest.suite());
    }

    public DecGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(DecGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigDecimal>(new BigDecimal(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        DecGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        DecGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        DecGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        DecGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        DecGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        DecGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            DecGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            DecGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            DecGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigDecimal)((Object)this.b));
        this.d = this.c.subtract((BigDecimal)((Object)this.b));
        DecGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigDecimal bigDecimal = (BigDecimal)this.fac.coFac.random(this.kl);
        this.b = new GenPolynomial<BigDecimal>(this.fac, bigDecimal, expVector);
        this.c = this.a.sum((BigDecimal)((Object)this.b));
        this.d = this.a.sum(bigDecimal, expVector);
        DecGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigDecimal)((Object)this.b));
        this.d = this.a.subtract(bigDecimal, expVector);
        DecGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigDecimal>(this.fac);
        this.b = new GenPolynomial<BigDecimal>(this.fac, bigDecimal, expVector);
        this.c = this.b.sum((BigDecimal)((Object)this.a));
        this.d = this.a.sum(bigDecimal, expVector);
        DecGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigDecimal)((Object)this.b));
        this.d = this.a.subtract(bigDecimal, expVector);
        DecGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        DecGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        DecGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigDecimal)((Object)this.a));
        this.d = this.a.multiply((BigDecimal)((Object)this.b));
        DecGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        DecGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigDecimal)((Object)this.c));
        DecGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        DecGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        DecGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigDecimal)((Object)this.b.multiply((BigDecimal)((Object)this.c))));
        this.e = this.a.multiply((BigDecimal)((Object)this.b)).multiply(this.c);
        DecGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        DecGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigDecimal bigDecimal = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(bigDecimal);
        DecGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigDecimal bigDecimal2 = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(bigDecimal2);
        DecGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<BigDecimal>(this.fac, bigDecimal2);
        this.d = this.b.multiply((BigDecimal)((Object)this.e));
        DecGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((BigDecimal)((Object)this.b));
        DecGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
    }

    public void testBLAS1() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, 3, this.el * this.el, this.q);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigDecimal bigDecimal = (BigDecimal)this.fac.coFac.random(this.kl);
        this.d = this.a.subtractMultiple(bigDecimal, this.b);
        this.e = this.a.subtract((BigDecimal)((Object)this.b.multiply(bigDecimal)));
        DecGenPolynomialTest.assertEquals((String)"a - (lc) b == a - ((lc) b)", this.d, this.e);
        this.d = this.a.subtractMultiple(bigDecimal, expVector, this.b);
        this.e = this.a.subtract((BigDecimal)((Object)this.b.multiply(bigDecimal, expVector)));
        DecGenPolynomialTest.assertEquals((String)"a - (lc ev) b == a - ((lc ev) b)", this.d, this.e);
        ExpVector expVector2 = ExpVector.random(this.rl, this.el, this.q);
        BigDecimal bigDecimal2 = (BigDecimal)this.fac.coFac.random(this.kl);
        this.d = this.a.scaleSubtractMultiple(bigDecimal2, bigDecimal, expVector, this.b);
        this.e = this.a.multiply(bigDecimal2).subtract((BigDecimal)((Object)this.b.multiply(bigDecimal, expVector)));
        DecGenPolynomialTest.assertEquals((String)"(tc) a - (lc ev) b == ((tc) a - ((lc ev) b))", this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(bigDecimal2, expVector2, bigDecimal, expVector, this.b);
        this.e = this.a.multiply(bigDecimal2, expVector2).subtract((BigDecimal)((Object)this.b.multiply(bigDecimal, expVector)));
        DecGenPolynomialTest.assertEquals((String)"(tc fv) a - (lc ev) b == ((tc fv) a - ((lc ev) b))", this.d, this.e);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigDecimal)((Object)this.b.sum((BigDecimal)((Object)this.c))));
        this.e = this.a.multiply((BigDecimal)((Object)this.b)).sum((GenPolynomial<BigDecimal>)this.a.multiply((BigDecimal)((Object)this.c)));
        DecGenPolynomialTest.assertEquals((String)"a(b+c) == ab+ac", this.d, this.e);
    }

    public void testAdditionSpeed() {
        int n = 100;
        long l = 1000L;
        boolean bl = false;
        int n2 = 1;
        for (int i = 1; i < 5; ++i) {
            for (int j = 1; j < 5; ++j) {
                this.a = this.fac.random(this.kl, j * n, this.el, this.q);
                this.b = this.fac.random(this.kl, n, this.el, this.q);
                for (int k = 0; k < n2; ++k) {
                    long l2 = System.nanoTime();
                    this.c = this.a.sum((BigDecimal)((Object)this.b));
                    l2 = System.nanoTime() - l2;
                    DecGenPolynomialTest.assertTrue((String)"c != 0", (!this.c.isZERO() ? 1 : 0) != 0);
                    long l3 = System.nanoTime();
                    this.d = this.b.sum((BigDecimal)((Object)this.a));
                    l3 = System.nanoTime() - l3;
                    DecGenPolynomialTest.assertTrue((String)"d != 0", (!this.d.isZERO() ? 1 : 0) != 0);
                    if (!bl) continue;
                    System.out.print("#a = " + this.a.length() + ", #b = " + this.b.length());
                    System.out.println(",\t t1 = " + l2 / l + ", t2 = " + l3 / l);
                }
                if (bl) {
                    System.out.println();
                }
                DecGenPolynomialTest.assertEquals((String)"c == d", this.c, this.d);
            }
            n = 3 * n;
        }
    }

    public void testAbsNorm() {
        this.a = ((GenPolynomial)this.fac.getONE()).negate();
        BigDecimal bigDecimal = PolyUtil.absNorm(this.a);
        DecGenPolynomialTest.assertTrue((String)"isONE( absNorm(-1) )", (boolean)bigDecimal.isONE());
        this.a = this.fac.random(this.kl * 2, this.ll + 2, this.el, this.q);
        bigDecimal = PolyUtil.absNorm(this.a);
        DecGenPolynomialTest.assertTrue((String)" not isZERO( absNorm(a) )", (!bigDecimal.isZERO() || this.a.isZERO() ? 1 : 0) != 0);
    }
}

