/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.PairList;
import edu.jas.gbufd.GroebnerBasePseudoRecParallel;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseQuotient<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<Quotient<C>> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseQuotient.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<GenPolynomial<C>> bba;

    public GroebnerBaseQuotient(QuotientRing<C> quotientRing) {
        this(new GroebnerBasePseudoRecSeq(quotientRing.ring));
    }

    public GroebnerBaseQuotient(int n, QuotientRing<C> quotientRing) {
        this(new GroebnerBasePseudoRecParallel(n, quotientRing.ring));
    }

    public GroebnerBaseQuotient(QuotientRing<C> quotientRing, PairList<GenPolynomial<C>> pairList) {
        this(new GroebnerBasePseudoRecSeq<C>(quotientRing.ring, pairList));
    }

    public GroebnerBaseQuotient(int n, QuotientRing<C> quotientRing, PairList<GenPolynomial<C>> pairList) {
        this(new GroebnerBasePseudoRecParallel<C>(n, quotientRing.ring, pairList));
    }

    public GroebnerBaseQuotient(GroebnerBaseAbstract<GenPolynomial<C>> groebnerBaseAbstract) {
        this.bba = groebnerBaseAbstract;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.bba.toString() + ")";
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> GB(int n, List<GenPolynomial<Quotient<C>>> list) {
        List<GenPolynomial<Quotient<C>>> list2 = list;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        QuotientRing quotientRing = (QuotientRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(quotientRing.ring, genPolynomialRing);
        List list3 = PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing2, list);
        logger.info("#Fi = " + list3.size());
        List list4 = this.bba.GB(n, list3);
        logger.info("#Gi = " + list4.size());
        list2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, list4);
        list2 = PolyUtil.monic(list2);
        return list2;
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> minimalGB(List<GenPolynomial<Quotient<C>>> list) {
        Iterable iterable;
        if (list == null || list.size() <= 1) {
            return list;
        }
        List<GenPolynomial<Quotient<C>>> iterable3 = new ArrayList<GenPolynomial<Quotient<C>>>(list.size());
        for (GenPolynomial<Quotient<C>> iterable22 : list) {
            if (iterable22 == null || iterable22.isZERO()) continue;
            iterable3.add(iterable22);
        }
        if (iterable3.size() <= 1) {
            return iterable3;
        }
        ArrayList arrayList = new ArrayList(iterable3.size());
        while (iterable3.size() > 0) {
            GenPolynomial genPolynomial = (GenPolynomial)iterable3.remove(0);
            if (this.red.isTopReducible(iterable3, genPolynomial) || this.red.isTopReducible(arrayList, genPolynomial)) {
                if (!debug) continue;
                System.out.println("dropped " + genPolynomial);
                iterable = new ArrayList(iterable3);
                iterable.addAll(arrayList);
                if ((genPolynomial = this.red.normalform(iterable, genPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genPolynomial);
                continue;
            }
            arrayList.add(genPolynomial);
        }
        iterable3 = arrayList;
        if (iterable3.size() <= 1) {
            return iterable3;
        }
        iterable = ((GenPolynomial)iterable3.get((int)0)).ring;
        QuotientRing quotientRing = (QuotientRing)((GenPolynomialRing)iterable).coFac;
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(quotientRing.ring, (GenPolynomialRing)iterable);
        List list2 = PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing, arrayList);
        logger.info("#Fi = " + list2.size());
        List<GenPolynomial<GenPolynomial<C>>> list3 = this.bba.minimalGB(list2);
        logger.info("#Gi = " + list3.size());
        iterable3 = PolyUfdUtil.quotientFromIntegralCoefficients(iterable, list3);
        iterable3 = PolyUtil.monic(iterable3);
        return iterable3;
    }

    @Override
    public void terminate() {
        this.bba.terminate();
    }

    @Override
    public int cancel() {
        return this.bba.cancel();
    }
}

