/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.QuotientRing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBasePseudoRecSeqTest
extends TestCase {
    GenPolynomialRing<GenPolynomial<BigInteger>> fac;
    List<GenPolynomial<GenPolynomial<BigInteger>>> L;
    PolynomialList<GenPolynomial<BigInteger>> F;
    List<GenPolynomial<GenPolynomial<BigInteger>>> G;
    GroebnerBaseAbstract<GenPolynomial<BigInteger>> bb;
    GroebnerBaseAbstract<GenPolynomial<BigRational>> bbr;
    GenPolynomial<GenPolynomial<BigInteger>> a;
    GenPolynomial<GenPolynomial<BigInteger>> b;
    GenPolynomial<GenPolynomial<BigInteger>> c;
    GenPolynomial<GenPolynomial<BigInteger>> d;
    GenPolynomial<GenPolynomial<BigInteger>> e;
    int rl = 2;
    int kl = 2;
    int ll = 5;
    int el = 4;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBasePseudoRecSeqTest.suite());
        ComputerThreads.terminate();
    }

    public GroebnerBasePseudoRecSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBasePseudoRecSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1);
        this.fac = new GenPolynomialRing<BigInteger>(genPolynomialRing, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBasePseudoRecSeq<BigInteger>(genPolynomialRing);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testRecSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<GenPolynomial<BigInteger>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.getZERO();
        this.e = this.c;
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        if (this.bb.commonZeroTest(this.L) < 0) {
            this.L.clear();
        }
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testHawes2GBase() {
        String string = "IntFunc(a, c, b) (y2, y1, z1, z2, x) G(( x + 2 y1 z1 + { 3 a } y1^2 + 5 y1^4 + { 2 c } y1 ),( x + 2 y2 z2 + { 3 a } y2^2 + 5 y2^4 + { 2 c } y2 ),( 2 z2 + { 6 a } y2 + 20 y2^3 + { 2 c } ),( 3 z1^2 + y1^2 + { b } ),( 3 z2^2 + y2^2 + { b } ))";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePseudoRecSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePseudoRecSeqTest.fail((String)("" + iOException));
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)polynomialList.ring.coFac;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        this.fac = new GenPolynomialRing<BigInteger>(genPolynomialRing2, polynomialList.ring);
        this.L = PolyUfdUtil.integerFromRationalCoefficients(this.fac, polynomialList.list);
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.L);
        l = System.currentTimeMillis() - l;
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)this.bb.isGB(this.G));
        GroebnerBasePseudoRecSeqTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)this.G.size());
        PolynomialList<GenPolynomial<BigInteger>> polynomialList2 = new PolynomialList<GenPolynomial<BigInteger>>(this.fac, this.G);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"nonsense ", (!polynomialList2.getList().isEmpty() ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)polynomialList.ring.coFac;
        List list = polynomialList.list;
        this.bbr = new GroebnerBasePseudoRecSeq<BigRational>(genPolynomialRing3);
        long l2 = System.currentTimeMillis();
        List list2 = this.bbr.GB(list);
        l2 = System.currentTimeMillis() - l2;
        list2 = PolyUtil.monicRec(list2);
        PolynomialList polynomialList3 = new PolynomialList(polynomialList.ring, list2);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"nonsense ", (!polynomialList3.getList().isEmpty() ? 1 : 0) != 0);
        List list3 = PolyUfdUtil.fromIntegerCoefficients(polynomialList.ring, this.G);
        list3 = PolyUtil.monicRec(list3);
        GroebnerBasePseudoRecSeqTest.assertEquals((String)"ratGB == intGB", list3, list2);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"nonsense ", (l2 >= 0L ? 1 : 0) != 0);
        QuotientRing quotientRing = new QuotientRing(genPolynomialRing3);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(quotientRing, this.fac);
        List list4 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, list);
        list4 = PolyUtil.monic(list4);
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq();
        long l3 = System.currentTimeMillis();
        List list5 = groebnerBaseSeq.GB(list4);
        l3 = System.currentTimeMillis() - l3;
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)groebnerBaseSeq.isGB(list5));
        GroebnerBasePseudoRecSeqTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)list5.size());
        PolynomialList polynomialList4 = new PolynomialList(genPolynomialRing4, list5);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"nonsense ", (!polynomialList4.getList().isEmpty() ? 1 : 0) != 0);
        List list6 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, list2);
        list6 = PolyUtil.monic(list6);
        GroebnerBasePseudoRecSeqTest.assertEquals((String)"ratGB == quotGB", list6, list5);
        QuotientRing<BigInteger> quotientRing2 = new QuotientRing<BigInteger>(genPolynomialRing2);
        GenPolynomialRing<BigInteger> genPolynomialRing5 = new GenPolynomialRing<BigInteger>(quotientRing2, this.fac);
        List list7 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing5, this.L);
        list7 = PolyUtil.monic(list7);
        GroebnerBaseSeq groebnerBaseSeq2 = new GroebnerBaseSeq();
        long l4 = System.currentTimeMillis();
        List list8 = groebnerBaseSeq2.GB(list7);
        l4 = System.currentTimeMillis() - l4;
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)groebnerBaseSeq2.isGB(list8));
        GroebnerBasePseudoRecSeqTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)list8.size());
        PolynomialList<BigInteger> polynomialList5 = new PolynomialList<BigInteger>(genPolynomialRing5, list8);
        GroebnerBasePseudoRecSeqTest.assertTrue((String)"nonsense ", (!polynomialList5.getList().isEmpty() ? 1 : 0) != 0);
        List list9 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing5, this.G);
        list9 = PolyUtil.monic(list9);
        GroebnerBasePseudoRecSeqTest.assertEquals((String)"quotRatGB == quotIntGB", list8, list9);
        System.out.println("time: ratGB = " + l2 + ", intGB = " + l + ", quotRatGB = " + l3 + ", quotIntGB = " + l4);
    }
}

