/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseSeqTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> G;
    PolynomialList<BigRational> F;
    GroebnerBaseAbstract<BigRational> bb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 4;
    int kl = 7;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseSeqTest.suite());
    }

    public GroebnerBaseSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseSeq<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        String string2 = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseSeqTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }

    public void testSequentialExtendedGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        ExtendedGB<BigRational> extendedGB = this.bb.extGB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(extendedGB.G));
        GroebnerBaseSeqTest.assertTrue((String)"isRmat( { a } )", (boolean)this.bb.isReductionMatrix(extendedGB));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        extendedGB = this.bb.extGB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(extendedGB.G));
        GroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b } )", (boolean)this.bb.isReductionMatrix(extendedGB));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        extendedGB = this.bb.extGB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(extendedGB.G));
        GroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b, c } )", (boolean)this.bb.isReductionMatrix(extendedGB));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        extendedGB = this.bb.extGB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(extendedGB.G));
        GroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b, c, d } )", (boolean)this.bb.isReductionMatrix(extendedGB));
        GroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        extendedGB = this.bb.extGB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(extendedGB.G));
        GroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b, c, d, e } )", (boolean)this.bb.isReductionMatrix(extendedGB));
    }

    public void testTrinks7ExtendedGBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        ExtendedGB<BigRational> extendedGB = this.bb.extGB(this.F.list);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(extendedGB.G));
        GroebnerBaseSeqTest.assertTrue((String)"isRmat( GB(Trinks7) )", (boolean)this.bb.isReductionMatrix(extendedGB));
    }

    public void testTrinks7GBaseSyz() {
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist());
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        String string2 = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        this.G = groebnerBaseSeq.GB(this.F.list);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseSeq.isGB(this.G));
        GroebnerBaseSeqTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        GroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
    }

    public void testTrinks7GBaseMin() {
        this.bb = new GroebnerBaseSeq<BigRational>(new ReductionSeq(), new OrderedMinPairlist());
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseSeqTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }

    public void testSequentialGBaseBoth() {
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.a.isONE());
        do {
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.b.isZERO() || this.b.isONE());
        do {
            this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.c.isZERO() || this.c.isONE());
        do {
            this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.d.isZERO() || this.d.isONE());
        this.e = this.d;
        this.L.add(this.a);
        List list = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(list));
        list = groebnerBaseSeq.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)groebnerBaseSeq.isGB(list));
        GroebnerBaseSeqTest.assertEquals((String)"isGBsimple(G) == isGBidem(G)", (boolean)this.bb.isGB(list), (boolean)this.bb.isGB(list, false));
        list.add(this.b);
        this.L = list;
        list = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(list));
        list = groebnerBaseSeq.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)groebnerBaseSeq.isGB(list));
        GroebnerBaseSeqTest.assertEquals((String)"isGBsimple(G) == isGBidem(G)", (boolean)this.bb.isGB(list), (boolean)this.bb.isGB(list, false));
        list.add(this.c);
        this.L = list;
        list = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(list));
        list = groebnerBaseSeq.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)groebnerBaseSeq.isGB(list));
        GroebnerBaseSeqTest.assertEquals((String)"isGBsimple(G) == isGBidem(G)", (boolean)this.bb.isGB(list), (boolean)this.bb.isGB(list, false));
        list.add(this.d);
        this.L = list;
        list = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(list));
        list = groebnerBaseSeq.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)groebnerBaseSeq.isGB(list));
        GroebnerBaseSeqTest.assertEquals((String)"isGBsimple(G) == isGBidem(G)", (boolean)this.bb.isGB(list), (boolean)this.bb.isGB(list, false));
        list.add(this.e);
        this.L = list;
        list = this.bb.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(list));
        list = groebnerBaseSeq.GB(this.L);
        GroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)groebnerBaseSeq.isGB(list));
        GroebnerBaseSeqTest.assertEquals((String)"isGBsimple(G) == isGBidem(G)", (boolean)this.bb.isGB(list), (boolean)this.bb.isGB(list, false));
    }
}

